function [pivots_out,cc_out,stk,stk_bw,output_dir] = find_centroidvstk(varargin)
%This function is used to find the 3d centroid of a set of images in a
%directory, virutal stacks baby.
%Synatax:   [pivots,centroid_img,lum_img] = find_centroidvstk('dirname',array,
%                               'theshold',0.5,'type',2,'type2',1,'norm',1)
%Input:     'dirname' = directory where the images are
%           'threshold' = if left off no threshold will be given, if given
%               the value should be between [0 1], and only maxima above
%               the desired level will be counted. Now by Default threshold
%               is 10% or 0.1 for localmax, centroids = 0.1 or 10%.  Now
%               the function will allow you to iterate through a number of
%               threshold you enter, essentially in the format:
%               (0.1,0.05...)
%           type = 1(centroid), 2 (WeightedCentroid) or 0(local max),
%               default = 0(local max)
%           type2 = 1(Area), 2(Max Intensity), 3(Min Intensity, 4(Pixel #)
%                   default = 0(Mean Intensity) Note: only works with
%                   centroids
%           norm = normalize the images, essentially stretching the image
%                   data over the full bit range.  Only works in centroid
%                   mode.  Default = 1, or on, and will not affect the
%                   intensity  measurements, now matches threshold.
%           object = out put the images of the objects.  Default = 0(off)
%               Does not work with local max
%           zfilter = requires the objects to be in more than 1 z slice
%           dirout = the output directory.  If not specified the output
%               directory will be in the root of the selected folder.
%           save = save out the images or not default = 1 (yes)
%           finetime = output directory contain hour and miniutes if
%               finetime is turned on. default = 0 (off)
%           savram = used in imnorm.  Check that function for info.
%Output:    pivots = a x by 4 array, where x y z define the pivots
%               and the brightness of the centroid is the 4th column.
%           centroid_img = the stacks reduced to the centroids.
%           lum_img = the points with the actual brightness levels for each
%               local max
%           cc_out = a cell array with the cc structure for each threshold
%           stk = the image stack used to find the centroids
%           stk_bw = the stack mask
%           output_dir = the output directory

[threshold,dirname,type,type2,norm,object,zfilter,dir_out,sav,finetime,savram,stk] = parse(varargin);

%initiate labeling of matrix (happy now?!)
mxlabel = {'x','y','z'};
output_dir = {};

if isempty(stk)  %if no stacks are entered, get one
    %grab the filenames in the directory
    dir_struct = dir(dirname);  %grab the directory information
    idx = [dir_struct.isdir];   %grab all of the isdir numbers
    filenames = {dir_struct.name};   %grab the all of the names in the root
    filenames = filenames(~idx);  %don't want the directory names
    
    %Put the virtual stack into an actual volume
    [filenames] = findimgs(filenames);   %make sure we only take the image names
    info = imfinfo([dirname,filesep,filenames{1}]);     %grab the file info
    
    switch info.BitDepth    %what is the bit depth
        case 8
            imgclass = 'uint8';
        case 16
            imgclass = 'uint16';
        case 32
            imgclass = 'uint32';
        otherwise
            imgclass = 'double';
    end
    stk = zeros(info.Height,info.Width,size(filenames,2),imgclass); %generate holder variable
    
    h = waitbar(0,'Opening Image: ','position',[10 50 275 50]);     %initiate progress bar
    for i = 1:size(filenames,2)
        waitbar(i/size(filenames,2),h,['Opening Image: ',filenames{i}]);   %update progress
        stk(:,:,i) = imread([dirname,filesep,filenames{i}]);  %grab the image
    end
    close(h)
else  %stack is entered
    info = whos('stk');  %get the info for the stk
    imgclass = info.class;  %note you can get image size from this structure as well.
    i = 1;
end

stk_tmp = stk;        %make a copy of the stack to work on.
for m = 1:size(threshold,2)     %iterate for number of threshold
    %normalize, only if needed
    if m==1||norm(m)~=norm(m-1)
        if norm(m)==1  %normalize
            stk_tmp = imnorm(stk_tmp,[],[],savram);    %normalize the image so that the bit depth is maximized.
        elseif norm(m)>0 && norm(m)<1     %imadjust mode
            lo_hi = stretchlim(max(stk_tmp,[],3),[0 norm(m)]);   %generate the contrast range
            for l = 1:size(stk_tmp,3)   %enhance each image
                stk_tmp(:,:,l) = imadjust(stk_tmp(:,:,l),lo_hi,[]);
            end
        end
    end
    stk_bw = false(size(stk_tmp));
    for j = 1:size(stk,3)     %make the img Black & White
        stk_bw(:,:,j) = im2bw(stk_tmp(:,:,j),threshold(m));
    end
    stk_cc = bwconncomp(stk_bw);    %run the connected components analysis
    if zfilter(m)
        pixlst = regionprops(stk_cc,'PixelList');   %find the objects in the volume
        pixidxlst = regionprops(stk_cc,'PixelIdxList');     %get the pixel indexs for the objects
        pixlst = struct2cell(pixlst);    %convert to cell for simple useage
        for n = 1:size(pixlst,2)        %step through the array
            pixtmp(n) = size(unique(pixlst{1,n}(:,3)),1);   %we only care about whether the z is single slice or multi
        end
        rmvidx = find(pixtmp==1);   %find the single slice objects
        pixidxlst(rmvidx) = [];     %remove the single slice objects
        %now convert back to image for later calculations...admittedly I don't
        %need to do this, but to keep the rest of the function the same, I will
        %do this extra step.
        object_idx = cell2mat(struct2cell(pixidxlst)');    %grab the indexs of all of the pixels
        object_tmp = false(size(stk_bw));    %stack holder
        object_tmp(object_idx) = 1;     %create the image
        stk_cc = bwconncomp(object_tmp);   %store
    end
    %stk_bw = [];
    switch type
        case 1    %Centroid
            pivots = regionprops(stk_cc,'Centroid');  %find centroid
            %pivots_out_tmp = cat(1,pivots.Centroid);
        case 2    %WeightedCentroid
            pivots = regionprops(stk_cc,stk,'WeightedCentroid');
            %pivots_out_tmp = cat(1,pivots.WeightedCentroid);
    end
    if ~isempty(pivots)  %if pivots are empty, no objects thus finish
        lum = [];
        for o = 1:size(type2,2)
            switch type2(o)
                case 1      %area
                    lum_tmp = regionprops(stk_cc,'Area');
                    lum_tmp = struct2cell(lum_tmp);
                    lum = horzcat(lum,cell2mat(lum_tmp)');
                    if m==1 %do this once
                        mxlabel = [mxlabel 'Area']; %generate the label in order
                    end
                case 2      %max intensity
                    lum_tmp = regionprops(stk_cc,stk,'MaxIntensity');
                    lum_tmp = struct2cell(lum_tmp);
                    lum = horzcat(lum,cell2mat(lum_tmp)');
                    if m==1
                        mxlabel = [mxlabel 'MaxIntensity'];
                    end
                case 3      %min intensity
                    lum_tmp = regionprops(stk_cc,stk,'MinIntensity');
                    lum_tmp = struct2cell(lum_tmp);
                    lum = horzcat(lum,cell2mat(lum_tmp)');
                    if m==1
                        mxlabel = [mxlabel 'MinIntensity'];
                    end
                case 4      %Pixel Number
                    lum_tmp = regionprops(stk_cc,'PixelIdxList');
                    lum_tmp = struct2cell(lum_tmp);
                    for l = 1:size(lum_tmp,2); lum_tmp{l} = size(lum_tmp{l},1); end
                    lum = horzcat(lum,cell2mat(lum_tmp)');
                    if m==1
                        mxlabel = [mxlabel 'VoxelNumber'];
                    end
                case 5      %Intensity Integrated
                    lum_tmp = regionprops(stk_cc,stk,'PixelValue');
                    lum_tmp = struct2cell(lum_tmp);
                    for l = 1:size(lum_tmp,2); lum_tmp{l} = sum(lum_tmp{l}); end
                    lum = horzcat(lum,cell2mat(lum_tmp)');
                    if m==1
                        mxlabel = [mxlabel 'IntegratedIntensity'];
                    end
                otherwise
                    lum_tmp = regionprops(stk_cc,stk,'MeanIntensity');    %find the intensity of the regions
                    lum_tmp = struct2cell(lum_tmp);
                    lum = horzcat(lum,cell2mat(lum_tmp)');
                    if m==1
                        mxlabel = [mxlabel 'MeanIntensity'];
                    end
            end
            lum_tmp = [];
        end
        centroid_tmp = false(size(stk));  %create a logical array the same size as the original array
        %pivots is currently a structure, convert to cell then matrix
        pivots = cell2mat(struct2cell(pivots)');
        %now make the pivots output by adding lum
        pivots_out_tmp = [pivots lum];
        %round pivots to use as pixel indexs
        pivots = round(pivots);
        %now calculate the indexs for the centroid locations
        [x,y,z] = size(centroid_tmp);        %stack size
        pivots_idx = ((pivots(:,1)-1).*x)+pivots(:,2)+((x*y).*(pivots(:,3)-1));
        %modify img_tmp
        centroid_tmp(pivots_idx) = 1;
        
        centroid_img = centroid_tmp;
        pivots_tmp = pivots_out_tmp;
        if object   %if object is on
            object_idx = cell2mat(struct2cell(regionprops(stk_cc,'PixelIdxList'))');    %grab the indexs of all of the pixels
            object_tmp = false(size(stk));    %stack holder
            object_tmp(object_idx) = 1;     %create the image
            object_img = object_tmp;   %store
            switch imgclass
                case 'uint8'
                    object_lum = stk.*uint8(object_img);   %preserve the luminance.
                case 'uint16'
                    object_lum = stk.*uint16(object_img);   %preserve the luminance.
                case 'uint32'
                    object_lum = stk.*uint32(object_img);   %preserve the luminance.
                case 'double'
                    object_lum = stk.*double(object_img);   %preserve the luminance.
            end
            object_tmp = []; %clear!
        end
        %clear img_tmp pivots_out_tmp img_bw
        pivots_out_tmp = [];centroid_tmp = [];
        
        %Now pickup the brightness at the max for each centroid (single
        %point remember)
        switch imgclass
            case 'uint8'
                lum_img = stk.*uint8(centroid_img);
            case 'uint16'
                lum_img = stk.*uint16(centroid_img);
            case 'uint32'
                lum_img = stk.*uint32(centroid_img);
            case 'double'
                lum_img = stk.*double(centroid_img);
        end
        
        if sav  %save out only if we want to
            %dynamic path
            if isempty(dir_out)  %not selected output directory
                sep_loc = strfind(dirname,filesep);
                dir_out = dirname(1:sep_loc(end));  %the root of the selected directory.
            end
            if finetime
                switch type
                    case 0
                        dir_path{m} = ['LocalMaxs',datestr(now,'yyyymmdd.HHMM'),'_t',num2str(threshold(m)),'z',num2str(zfilter(m)),'n',num2str(norm(m)),filesep];     %where to save it
                        object = 0;     %force this, because local max has no object
                    case 1
                        dir_path{m} = ['Centroids',datestr(now,'yyyymmdd.HHMM'),'_t',num2str(threshold(m)),'z',num2str(zfilter(m)),'n',num2str(norm(m)),filesep];     %where to save it
                    case 2
                        dir_path{m} = ['WeightedCentroids',datestr(now,'yyyymmdd.HHMM'),'_t',num2str(threshold(m)),'z',num2str(zfilter(m)),'n',num2str(norm(m)),filesep];     %where to save it
                end
            else
                switch type
                    case 0
                        dir_path{m} = ['LocalMaxs',datestr(now,'yyyymmdd'),'_t',num2str(threshold(m)),'z',num2str(zfilter(m)),'n',num2str(norm(m)),filesep];     %where to save it
                        object = 0;     %force this, because local max has no object
                    case 1
                        dir_path{m} = ['Centroids',datestr(now,'yyyymmdd'),'_t',num2str(threshold(m)),'z',num2str(zfilter(m)),'n',num2str(norm(m)),filesep];     %where to save it
                    case 2
                        dir_path{m} = ['WeightedCentroids',datestr(now,'yyyymmdd'),'_t',num2str(threshold(m)),'z',num2str(zfilter(m)),'n',num2str(norm(m)),filesep];     %where to save it
                end
            end
            warning('OFF')
            mkdir(dir_out,dir_path{m});      %create output directory
            mkdir(dir_out,[dir_path{m},'img_data',filesep]);     %create a directory where the file information is stored
            %now save the files
            stridx = strfind(dirname,filesep);  %create a label for the file
            stklabel = dirname(stridx(end)+1:end);
            
            mkdir([dir_out,dir_path{m}],stklabel);
            xls_exp = dataset({pivots_tmp,mxlabel{:}});               %to export as a XLS need to make the data a dataset.
            export(xls_exp,'File',[[dir_out,dir_path{m}],[stklabel,'.',num2str(size(pivots_tmp,1)),'.csv']],'delimiter',',')
            mkdir([dir_out,dir_path{m},stklabel],['lum_imgs',filesep]);
            stk2tiff(lum_img,stklabel,[dir_out,dir_path{m},stklabel,filesep,'lum_imgs',filesep]);
            mkdir([dir_out,dir_path{m},stklabel],['centroid_imgs',filesep]);
            stk2tiff(centroid_img,stklabel,[dir_out,dir_path{m},stklabel,filesep,'centroid_imgs',filesep]);
            save([[dir_out,dir_path{m}],[stklabel,'_cc','.mat']],'stk_cc');
            if object   %save out the object stacks
                mkdir([dir_out,dir_path{m},stklabel],['objects_lum',filesep]);
                stk2tiff(object_lum,stklabel,[dir_out,dir_path{m},stklabel,filesep,'objects_lum',filesep]);
                mkdir([dir_out,dir_path{m},stklabel],['objects',filesep]);
                stk2tiff(object_img,stklabel,[dir_out,dir_path{m},stklabel,filesep,'objects',filesep]);
            end
            %save some info about the image
            img_data = size(stk);
            img_data = dataset(img_data);
            export(img_data,'File',[[dir_out,dir_path{m},'img_data',filesep],stklabel,'_img_data.csv'],'delimiter',',')
            if i==1
                %for historical reasons I am going to do this, just one more file no big
                export(img_data,'File',[[dir_out,dir_path{m},'img_data',filesep],'img_data.csv'],'delimiter',',')
            end
            warning('ON')
            output_dir{m} = [dir_out,dir_path{m}];
        end
    else
        %no objects - output empty
        pivots_tmp = [];
        stk_cc = [];
    end
    %output pivots
    pivots_out{m} = pivots_tmp;
    %output cc structure
    cc_out{m} = stk_cc;
    %clear data
    local_max_tmp = []; lum_tmp = []; xls_exp = [];centroid_img = [];lum_img = [];object_img = [];object_lum = [];pivots_tmp = [];stk_cc=[];
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [threshold,dirname,type,type2,norm,object,zfilter,dir_out,sav,finetime,savram,stk] = parse(input)

threshold = [];
type = 0;
type2 = 0;      %default is 0; now you can define the accessory data, acquired instead of Luminance
norm = 1;
object = 0;
dirname = [];
zfilter = 0;
dir_out = [];
sav = 1;
finetime = 0;
savram = 0;
stk = [];

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dirname'
                    dirname = input{1,i+1};
                case 'threshold'
                    threshold = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'type2'
                    type2 = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                case 'object'
                    object = input{1,i+1};
                case 'zfilter'
                    zfilter = input{1,i+1};
                case 'dirout'
                    dir_out = input{1,i+1};
                case 'save'
                    sav = input{1,i+1};
                case 'finetime'
                    finetime = input{1,i+1};
                case 'savram'
                    savram = input{1,i+1};
                case 'stk'
                    stk = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the images you want to open
if isempty(dirname)&&isempty(stk)
    dirname = uigetdir2('','Directory where your images are');    %get the directory
end
%set threshold, if the user have not already.
if isempty(threshold)
    switch type
        case 0   %default local max
            threshold = 0.1;
        otherwise  %centroid or weighted centroid
            threshold = 0.1;
    end
end
%make sure treshold and norm line up
if size(threshold,2)~=size(norm,2)   %align zfilter to threshold
    diff = size(threshold,2)-size(norm,2);   %the difference
    norm = horzcat(norm,ones(1,diff));   %pad with default
end
%make sure treshold and zfilter line up
if size(threshold,2)~=size(zfilter,2)   %align zfilter to threshold
    diff = size(threshold,2)-size(zfilter,2);   %the difference
    zfilter = horzcat(zfilter,zeros(1,diff));   %pad with default
end
%we are going to make sure the dirout has a filesep at the end.  You should
%also make sure the dirout is not a cell, if that could happen, not
%necessary now.
if ~isempty(dir_out)
    sep_loc = strfind(dir_out,filesep);     %find all of the filesep locations
    if sep_loc(end)~=size(dir_out,2)    %if the end does not have a filesep
        dir_out = [dir_out,filesep];    %add it
    end
end